﻿using System;
using System.Configuration;
using System.Security.Cryptography;
using System.Text;

namespace PlayerTestNET
{
    public class UserSettings : ApplicationSettingsBase
    {
        [UserScopedSetting()]
        [DefaultSettingValue("")]
        public string ServerUrl
        {
            get { return (string)this["ServerUrl"]; }
            set { this["ServerUrl"] = value; }
        }

        [UserScopedSetting()]
        [DefaultSettingValue("")]
        public string Username
        {
            get { return (string)this["Username"]; }
            set { this["Username"] = value; }
        }

        [UserScopedSetting()]
        [DefaultSettingValue("")]
        public string Password
        {
            get
            {
                try
                {
                    string value = (string)this["Password"];
                    if (string.IsNullOrEmpty(value))
                    {
                        return "";
                    }
                    byte[] encrypted = Convert.FromBase64String(value);
                    byte[] decrypted = ProtectedData.Unprotect(encrypted, null, DataProtectionScope.CurrentUser);
                    return Encoding.UTF8.GetString(decrypted);
                }
                catch (Exception e)
                {
                    Console.WriteLine("Error reading password from settings: {0}", e.Message);
                    return "";
                }
            }
            set
            {
                try
                {
                    byte[] decrypted = Encoding.UTF8.GetBytes(value);
                    byte[] encrypted = ProtectedData.Protect(decrypted, null, DataProtectionScope.CurrentUser);
                    this["Password"] = Convert.ToBase64String(encrypted);
                }
                catch (Exception e)
                {
                    Console.WriteLine("Error writing password to settings: {0}", e.Message);
                }
            }
        }


        [UserScopedSetting()]
        [DefaultSettingValue("0")]
        public int CameraId
        {
            get { return (int)this["CameraId"]; }
            set { this["CameraId"] = value; }
        }
    }
}
