﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Windows.Forms;

namespace PlayerTestNET
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.ThreadException += new ThreadExceptionEventHandler(OnThreadException);
            AppDomain.CurrentDomain.UnhandledException += new UnhandledExceptionEventHandler(OnUnhandledException);
            Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);

            try
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new MainForm());
            }
            catch (Exception e)
            {
                Application.OnThreadException(e);
            }
        }

        static private void OnThreadException(object sender, ThreadExceptionEventArgs t)
        {
            HandleException(t.Exception);
        }

        static private void OnUnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            if (e.IsTerminating)
            {
                return;
            }
            if (e.ExceptionObject is Exception)
            {
                HandleException((Exception)e.ExceptionObject);
            }
            else
            {
                MessageBox.Show("Unknown error.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        static private void HandleException(Exception e)
        {
            MessageBox.Show(e.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }
    }
}
