﻿using System;
using System.Windows.Forms;
using SkmXmlApi;

namespace PlayerTestNET
{
    public partial class MainForm : Form
    {
        private string m_ServerUrl;
        private string m_Username;
        private string m_Password;
        private SkmObjectList<Camera> m_Cameras;
        private UserSettings m_Settings;

        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            m_Settings = new UserSettings();
        }

        private void MainForm_Shown(object sender, EventArgs ea)
        {
            using (LoginDialog dialog = new LoginDialog())
            {
                if (dialog.ShowDialog() == DialogResult.OK)
                {
                    m_ServerUrl = dialog.ServerUrl;
                    m_Username = dialog.Username;
                    m_Password = dialog.Password;

                    LoadCameras();
                }
                else
                {
                    Close();
                }
            }
        }

        private void LoadCameras()
        {
            Cursor cursor = Cursor;
            Cursor = Cursors.WaitCursor;
            btLoadCameras.Enabled = false;
            btOpenPlayer.Enabled = false;
            try
            {
                m_Cameras = null;
                cbCameras.Items.Clear();

                // An Skm session must be created first and login performed.
                SkmSession session = SkmSession.NewSkmSession(m_ServerUrl);
                session.Login(m_Username, m_Password);

                // Create credentials command to get list of cameras.
                var cc = CredentialCommand.NewCredentialCommand(session);
                m_Cameras = cc.Cameras;
                foreach (Camera camera in m_Cameras)
                {
                    cbCameras.Items.Add(string.Format("[{0}] {1}", camera.Id, camera.Name));
                }

                Camera selected = m_Cameras?.Find(cam => cam.Id == m_Settings.CameraId);
                if (selected != null)
                {
                    cbCameras.SelectedIndex = m_Cameras.IndexOf(selected);
                }
                else if (cbCameras.Items.Count > 0)
                {
                    cbCameras.SelectedIndex = 0;
                }
            }
            finally
            {
                btLoadCameras.Enabled = true;
                btOpenPlayer.Enabled = m_Cameras != null && m_Cameras.Count > 0;
                Cursor = cursor;
            }
        }

        private void btGcCollect_Click(object sender, EventArgs e)
        {
            GC.Collect();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btLoadCameras_Click(object sender, EventArgs e)
        {
            LoadCameras();
        }

        private void btOpenPlayer_Click(object sender, EventArgs e)
        {
            if (m_Cameras == null || cbCameras.SelectedIndex < 0 || cbCameras.SelectedIndex >= m_Cameras.Count)
            {
                return;
            }
            PlayerForm form = new PlayerForm();
            form.MdiParent = this;
            form.Show(m_Cameras[cbCameras.SelectedIndex]);
        }

        private void cbCameras_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (m_Cameras != null && cbCameras.SelectedIndex >= 0 && cbCameras.SelectedIndex < m_Cameras.Count)
            {
                m_Settings.CameraId = m_Cameras[cbCameras.SelectedIndex].Id;
                m_Settings.Save();
            }
        }

        static public MainForm GetMainForm()
        {
            foreach (Form form in Application.OpenForms)
            {
                MainForm mainForm = form as MainForm;
                if (mainForm != null)
                {
                    return mainForm;
                }
            }
            return null;
        }

        static public string ServerUrl
        {
            get { return GetMainForm()?.m_ServerUrl;  }
        }

        static public string Username
        {
            get { return GetMainForm()?.m_Username; }
        }

        static public string Password
        {
            get { return GetMainForm()?.m_Password; }
        }
    }
}
