﻿using SkmXmlApi;
using System;
using System.Windows.Forms;

namespace PlayerTestNET
{
    public partial class LoginDialog : Form
    {
        private UserSettings m_Settings;

        public LoginDialog()
        {
            InitializeComponent();
        }

        private void LoginDialog_Load(object sender, EventArgs e)
        {
            m_Settings = new UserSettings();
            tbServer.Text = m_Settings.ServerUrl;
            tbUsername.Text = m_Settings.Username;
            tbPassword.Text = m_Settings.Password;
        }

        private void btOk_Click(object sender, EventArgs e)
        {
            Cursor cursor = Cursor;
            Cursor = Cursors.WaitCursor;
            btOk.Enabled = false;
            btCancel.Enabled = false;
            try
            {
                ServerUrl = tbServer.Text;
                Username = tbUsername.Text;
                Password = tbPassword.Text;

                SkmSession session = SkmSession.NewSkmSession(ServerUrl);
                session.Login(Username, Password);

                m_Settings.ServerUrl = ServerUrl;
                m_Settings.Username = Username;
                m_Settings.Password = Password;
                m_Settings.Save();

                DialogResult = DialogResult.OK;
            }
            finally
            {
                btOk.Enabled = true;
                btCancel.Enabled = true;
                Cursor = cursor;
            }
        }

        public string ServerUrl { get; private set; }
        public string Username { get; private set; }
        public string Password { get; private set; }
    }
}
