#ifndef INCLUDE_VCA_WEB_PARAMS_H_
#define INCLUDE_VCA_WEB_PARAMS_H_

/**
 * @file      vca/web/params.h
 * @copyright VCA Technology
 * @~english
 * @brief     Params for the HTTP server
 */

#include <vca/protocol/network/port.h>
#include <vca/web/macros.h>

#include <stddef.h>

struct VcaAuthenticationEngine;
struct VcaWebBackend;

/**
 * @~english
 * Internal extra params that should be null for users outside of VCA
 */
struct VcaWebExtraParams {
  /**
   * @~english
   * Pointer to the web backend that supports the specialized extra params
   */
  struct VcaWebBackend const* backend;
};

/**
 * @~english
 * Various params when starting the web server
 */
struct VcaWebParams {
  /**
   * @~english
   * The host to bind the web-server to.
   * @remarks If the value is set to a @c NULL or empty string, the web-server will be bound to a port on all network
   *   interfaces. A value of "0.0.0.0" have the same effect.
   *
   *   The value may also contain the name or address of a host to bind the port to such as "127.0.0.1", "localhost",
   *   "192.168.1.123" or "hostname.local".
   */
  const char* host;

  /**
   * @~english
   * The TCP port that the HTTP server should listen for connections on
   */
  VcaProtocolNetworkPort port;

  /**
   * @~english
   * The prefix root directory that the web will serve from.
   * @remarks If this value is @c NULL , or @c "" the web-server will serve with no directory prefix i.e.
   *   @c http://host/...
   *
   *   If the value is set to a value such as @c "/sub-directory" , the web-server will serve from
   *   @c http://host/sub-directory/... .
   */
  const char* root;

  /**
   * @~english
   * A pointer to the authentication engine that will be used to validate requests to the authentication engine.
   */
  const struct VcaAuthenticationEngine* authentication_engine;

  /**
   * @~english
   * An opaque object for internal extra parameters to the web server
   */
  const struct VcaWebExtraParams* extra_params;
};

/**
 * @~english
 * The default web server params
 */
#define VCA_WEB_PARAMS_DEFAULT \
  { NULL, 8080, NULL, NULL, NULL }

#endif  // INCLUDE_VCA_WEB_PARAMS_H_
