#ifndef INCLUDE_VCA_META_DATA_ID_H_
#define INCLUDE_VCA_META_DATA_ID_H_
/**
 * @file      vca/meta/data/id.h
 * @copyright VCA Technology
 * @~english
 * @brief     Identification number for meta data objects
 */

#include <vca/meta_data/macros.h>

#include <stdint.h>

VCA_META_DATA_EXTERN_C_BEGIN

/**
 * @~english
 * The id of a VCA meta-data object.
 */
typedef uint32_t VcaMetaDataId;  // NOLINT(modernize-use-using)

/**
 * @~english
 * An ID value that indicates an invalid object
 */
#define VCA_META_DATA_INVALID_ID (VcaMetaDataId)(~0)

VCA_META_DATA_EXTERN_C_END

#endif /* INCLUDE_VCA_META_DATA_ID_H_ */
