#ifndef INCLUDE_VCA_MEDIA_TIMESTAMP_H_
#define INCLUDE_VCA_MEDIA_TIMESTAMP_H_
/**
 * @file       vca/media/timestamp.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Declares the @c VcaMediaTimestamp type
 */

#include <vca/media/macros.h>

#include <stdint.h>

VCA_MEDIA_EXTERN_C_BEGIN

/**
 * Represents a media timestamp in nano-seconds since 1970 UTC.
 */
typedef uint64_t VcaMediaTimestamp;  // NOLINT(modernize-use-using)

/**
 * Converts an ISO 8601 formatted time string into a Vca timestamp.
 * @param iso8601 ISO 8601 formatted string
 * @return the converted timestamp
 */
VCA_MEDIA_DLL_PUBLIC
VcaMediaTimestamp VcaMediaTimestampFromIso8601(const char* iso8601);

VCA_MEDIA_EXTERN_C_END

#endif /* INCLUDE_VCA_MEDIA_TIMESTAMP_H_ */
