#ifndef INCLUDE_VCA_CORE_SDK_VIDEO_FORMAT_H_
#define INCLUDE_VCA_CORE_SDK_VIDEO_FORMAT_H_
/**
 * @file       vca/core_sdk/video/format.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Declares the @c VcaCoreVideoFormat structure.
 */

#include <vca/media/four_cc.h>
#include <vca/media/frame_rate.h>

/**
 * @~english
 * Describes the format of a video frame buffer.
 */
struct VcaCoreVideoFormat {
  /**
   * @~english
   * The fourcc of the video.
   */
  VcaMediaFourCc four_cc;

  /**
   * @~english
   * The frame rate of this video stream.
   */
  struct VcaMediaFrameRate frame_rate;

  /**
   * @~english
   * Width of the frame in pixels.
   */
  unsigned int width;

  /**
   * @~english
   * Height of the frame in pixels.
   */
  unsigned int height;
};

#endif /* INCLUDE_VCA_CORE_SDK_VIDEO_FORMAT_H_ */
