#ifndef INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_PLANE_H_
#define INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_PLANE_H_
/**
 * @file       vca/core_sdk/video/buffer/plane.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Declares the @c VcaCoreVideoBufferPlane structure.
 */

#include <vca/core_sdk/macros.h>

#include <stddef.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Describes the memory of a plane within media buffer.
 */
struct VcaCoreVideoBufferPlane {
  /**
   * @~english
   * The length of the plane data.
   */
  size_t size;

  /**
   * @~english
   * The offset of this plane within the data buffer.
   */
  size_t offset;

  /**
   * @~english
   * Number of bytes per horizontal line of the frame (width plus any padding) for each plane, or @c 0 if this value
   * is not applicable e.g. for compressed video data.
   */
  ptrdiff_t stride;
};

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_PLANE_H_ */
