#ifndef INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_H_
#define INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_H_
/**
 * @file       vca/core_sdk/video/buffer.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Declares the @c VcaCoreVideoBuffer structure.
 */

#include <vca/core_sdk/function/unreference.h>
#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/video/buffer/plane.h>

#include <stddef.h>
#include <stdint.h>

/**
 * @~english
 * Maximum number of planes in a video buffer
 */
#define VCA_CORE_VIDEO_BUFFER_MAX_PLANES 4

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Describes the memory of a media buffer.
 */
struct VcaCoreVideoBuffer {
  /**
   * @~english
   * The length of the data buffer
   */
  size_t size;

  /**
   * @~english
   * The pointer to the buffer data.
   */
  const uint8_t* data;

  /**
   * @~english
   * The number of planes in the video frame.
   */
  size_t plane_count;

  /**
   * @~english
   * The planes of video data.
   */
  struct VcaCoreVideoBufferPlane planes[VCA_CORE_VIDEO_BUFFER_MAX_PLANES];

  /**
   * @~english
   * A optional function pointer than will be invoked when the memory is no longer needed.
   */
  VcaCoreFunctionUnreference unreference;

  /**
   * @~english
   * Pointer that will be passed to the unreference function.
   */
  void* user_data;
};

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_VIDEO_BUFFER_H_ */
