#ifndef INCLUDE_VCA_CORE_SDK_VERSION_H_
#define INCLUDE_VCA_CORE_SDK_VERSION_H_

/**
 * @file      vca/core_sdk/version.h
 * @copyright VCA Technology
 * @~english
 * @brief     Defines the @c VcaCoreVersion structure.
 */

/**
 * @ingroup core_sdk
 * @~english
 * Defines the name and version of the VCA Core library.
 */
struct VcaCoreVersion {
  /**
   * @~english
   * The name of the attached library or application.
   */
  const char* name;

  /**
   * @~english
   * The major release number.
   */
  unsigned int major;

  /**
   * @~english
   * The minor release number.
   */
  unsigned int minor;

  /**
   * @~english
   * The patch number.
   */
  unsigned int patch;
};

#endif /* INCLUDE_VCA_CORE_SDK_VERSION_H_ */
