#ifndef INCLUDE_VCA_CORE_SDK_STATUS_MESSAGE_H_
#define INCLUDE_VCA_CORE_SDK_STATUS_MESSAGE_H_
/**
 * @file       vca/core_sdk/status_message.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Converts a VCA status into readable text
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/status.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @ingroup cored
 * @~english
 * Provides an explanatory string from a VCA status code
 * @par Example
 * @code
 * fprintf(stderr, "Error: %s", VcaCoreStatusMessage(VcaCoreInvalidParameter));
 * // Error: There was an invalid parameter
 * @endcode
 * @param status the status code returned from a VCA API call
 * @returns constant character string pointer
 */
VCA_CORE_SDK_DLL_PUBLIC
const char* VcaCoreStatusMessage(const enum VcaCoreStatus status);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_STATUS_MESSAGE_H_ */
