#ifndef INCLUDE_VCA_CORE_SDK_STATUS_H_
#define INCLUDE_VCA_CORE_SDK_STATUS_H_
/**
 * @file       vca/core_sdk/status.h
 * @copyright  VCA Technology
 * @~english
 * @brief      The status of a VCA API operation
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @ingroup cored
 * @~english
 * The result of a VCA cored API call
 */
enum VcaCoreStatus {
  /**
   * @~english
   * The operation was a success.
   */
  VcaCoreSuccess,

  /**
   * @~english
   * The API operation failed due to an internal failure, check the last error message for more information
   */
  VcaCoreFailure,

  /**
   * @~english
   * An invalid argument was provided to an API call and had to exit before performing any actions
   */
  VcaCoreInvalidParameter,
};

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_STATUS_H_ */
