#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_WAIT_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_WAIT_H_
/**
 * @file      vca/core_sdk/service/wait.h
 * @copyright VCA Technology
 * @~english
 * @brief     Waits for a VCA core service to gracefully exit
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options.h>
#include <vca/core_sdk/status.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Waits for a VCA core service to gracefully exit
 * @param service the service to wait on
 * @retval VcaStatusSuccess waiting on the service was a success
 * @returns the error status code in case of a failure
 */
VCA_CORE_SDK_DLL_PUBLIC
enum VcaCoreStatus VcaCoreServiceWait(struct VcaCoreService* const service);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_SERVICE_WAIT_H_ */
