#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_STOP_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_STOP_H_
/**
 * @file      vca/core_sdk/service/stop.h
 * @copyright VCA Technology
 * @~english
 * @brief     Stops a VCA core service
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options.h>
#include <vca/core_sdk/status.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Stops a VCA core service. Usually called in another thread to terminate a service.
 * @param service the service to stop
 * @retval VcaStatusSuccess stopping the service was a success
 * @returns the error status code in case of a failure
 */
VCA_CORE_SDK_DLL_PUBLIC
enum VcaCoreStatus VcaCoreServiceStop(struct VcaCoreService* const service);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_SERVICE_STOP_H_ */
