#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_RELEASE_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_RELEASE_H_
/**
 * @file      vca/core_sdk/service/release.h
 * @copyright VCA Technology
 * @~english
 * @brief     Frees a VCA core service handle
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Frees a service handle, reducing the reference count
 * @param service the handle to free
 */
VCA_CORE_SDK_DLL_PUBLIC
void VcaCoreServiceRelease(struct VcaCoreService* const service);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_SERVICE_RELEASE_H_ */
