#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_WEB_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_WEB_H_
/**
 * @file      vca/core_sdk/service/options/web.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the web server
 */

#include <vca/core_sdk/macros.h>
#include <vca/web/params.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to the services web server.
 */
struct VcaCoreServiceOptionsWeb {
  /**
   * @~english
   * The backend implementation to use to run the web server that will provide services for the process. Note that if
   * this field is set to @c NULL , the VCA Core default web server will be used.
   */
  const struct VcaWebBackend* backend;

  /**
   * @~english
   * The parameters that are used to start the web server
   */
  struct VcaWebParams server;

  /**
   * @~english
   * The root location to serve files from
   */
  const char* root;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsWeb</tt>. This can be used to initialize the structure if
 * needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsWeb web_options = VCA_CORE_OPTIONS_WEB_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_WEB_DEFAULT          \
  {                                           \
    NULL,                      /* backend */  \
    VCA_WEB_PARAMS_DEFAULT,    /* server */   \
    NULL,                      /* root */     \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_WEB_H_
