#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_USER_CHANNELS_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_USER_CHANNELS_H_
/**
 * @file      vca/core_sdk/service/options/user_channels.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options that are related to user configurable channels
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to user configurable channels.
 */
struct VcaCoreServiceOptionsUserChannels {
  /**
   * @~english
   * Whether to allow user-configured channels or not.
   */
  bool enabled;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsUserChannels</tt>. This can be used to initialize the structure
 * if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsUserChannels user_channels_options = VCA_CORE_OPTIONS_USER_CHANNELS_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_USER_CHANNELS_DEFAULT  \
  {                                             \
    false   /* enabled */                      \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_USER_CHANNELS_H_
