#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_TYPE_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_TYPE_H_
/**
 * @file      vca/core_sdk/service/options/type.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the VCA core library
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * An enum of the possible types of @c VcaCoreServiceOptions
 */
enum VcaCoreServiceOptionsType {
  // clang-format off
  VcaCoreServiceOptionsWebType             = 1,
  VcaCoreServiceOptionsStorageType         = 2,
  VcaCoreServiceOptionsRtspType            = 3,
  VcaCoreServiceOptionsCoreDumpType        = 4,
  VcaCoreServiceOptionsUserChannelsType    = 5,
  VcaCoreServiceOptionsActionsType         = 6,
  VcaCoreServiceOptionsImportType          = 7,
  VcaCoreServiceOptionsSecurityDaemonType  = 8,
  VcaCoreServiceOptionsCrashHandlerType    = 9,
  VcaCoreServiceOptionsProcessingModeType  = 10,
  VcaCoreServiceOptionsManagerType         = 11,
  VcaCoreServiceOptionsFilterMetadataType  = 12
  // clang-format on
};

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_TYPE_H_
