#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_STORAGE_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_STORAGE_H_
/**
 * @file      vca/core_sdk/service/options/storage.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the configuration storage
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to storage locations of the service
 */
struct VcaCoreServiceOptionsStorage {
  /**
   * @~english
   * The root folder where to store configuration data
   */
  const char* data_directory;

  /**
   * @~english
   * The folder where to store test clips
   * @remarks If unspecified this will default to @c data_directory / "test-clips"
   */
  const char* test_clips_directory;

  /**
   * @~english
   * The folder where to store pre-built engine files
   * @remarks If unspecified this will default to @c data_directory / "engines"
   */
  const char* engines_directory;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsStorage</tt>. This can be used to initialize the structure if
 * needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsStorage storage_options = VCA_CORE_OPTIONS_STORAGE_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_STORAGE_DEFAULT           \
  {                                                \
    NULL,                      /* configuration */ \
    NULL,                      /* test-clips    */ \
    NULL                       /* engines       */ \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_STORAGE_H_
