#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_SECURITY_DAEMON_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_SECURITY_DAEMON_H_
/**
 * @file      vca/core_sdk/service/options/core_dump.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the core_dump server
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to the services core_dump server.
 */
struct VcaCoreServiceOptionsSecurityDaemon {
  /**
   * @~english
   * Indicates whether the license daemon should be auto launched by vca-core when
   * using local daemon
   */
  bool auto_launch_daemon;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsSecurityDaemon</tt>. This can be used to initialize the
 * structure if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsSecurityDaemon security_daemon_options = VCA_CORE_OPTIONS_SECURITY_DAEMON_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_SECURITY_DAEMON_DEFAULT  \
  {                                         \
    true   /* auto_launch_daemon */                       \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_SECURITY_DAEMON_H_
