#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_RTSP_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_RTSP_H_
/**
 * @file      vca/core_sdk/service/options/rtsp.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the RTSP server
 */

#include <vca/core_sdk/macros.h>
#include <vca/protocol/network/port.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options related to the RTSP Server
 */
struct VcaCoreServiceOptionsRtsp {
  /**
   * @~english
   * Port
   */
  VcaProtocolNetworkPort port;
};

/**
 * @~english
 * The default RTSP port value
 */
// clang-format off
#define VCA_CORE_OPTIONS_RTSP_DEFAULT_PORT 8554

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsRtsp</tt>. This can be used to initialize the structure if
 * needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsRtsp rtsp_options = VCA_CORE_OPTIONS_RTSP_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_RTSP_DEFAULT  \
  {                                    \
    VCA_CORE_OPTIONS_RTSP_DEFAULT_PORT \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_RTSP_H_
