#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_PROCESSING_MODE_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_PROCESSING_MODE_H_

/**
 * @file      vca/core_sdk/service/options/processing_mode.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the Processing mode
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options related to the RTSP Server
 */
struct VcaCoreServiceOptionsProcessingMode {
  /**
   * @~english
   * A boolean specifying whether offline mode is to be used
   */
  bool offline;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsProcessingMode</tt>. This can be used to initialize the
 * structure if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsProcessingMode rtsp_options = VCA_CORE_OPTIONS_PROCESSING_MODE_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_PROCESSING_MODE_DEFAULT  \
  {                                               \
    false                                         \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_PROCESSING_MODE_H_
