#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_MANAGER_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_MANAGER_H_
/**
 * @file      vca/core_sdk/service/options/manager.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options that are related to manager service
 */

#include <vca/core_sdk/macros.h>
#include <vca/protocol/network/port.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to manager service.
 */
struct VcaCoreServiceOptionsManager {
  /**
   * @~english
   * The Port to use for communication between vca-core and the parent manager process
   */
  VcaProtocolNetworkPort port;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsManager</tt>. This can be used to initialize the structure
 * if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsManager manager_options = VCA_CORE_OPTIONS_MANAGER_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_MANAGER_DEFAULT  \
  {                                       \
    10878   /* port */                    \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_MANAGER_H_
