#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_IMPORT_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_IMPORT_H_
/**
 * @file      vca/core_sdk/service/options/import.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options that are related to importing configurations
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to importing configurations
 */
struct VcaCoreServiceOptionsImport {
  /**
   * @~english
   * Whether to allow configuration import or not
   */
  bool enabled;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsImport</tt>. This can be used to initialize the structure
 * if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsImport import_options = VCA_CORE_OPTIONS_IMPORT_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_IMPORT_DEFAULT  \
  {                                             \
    false   /* enabled */                      \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_IMPORT_H_
