#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CRASH_HANDLER_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CRASH_HANDLER_H_
/**
 * @file      vca/core_sdk/service/options/crash_handler.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options that are related to CrashHandler handler
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to CrashHandler.
 */
struct VcaCoreServiceOptionsCrashHandler {
  /**
   * @~english
   * Whether CrashHandler handler are enabled or not.
   */
  bool enabled;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsCrashHandler</tt>. This can be used to initialize the structure
 * if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsUserChannels user_channels_options = VCA_CORE_OPTIONS_CRASH_HANDLER_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_CRASH_HANDLER_DEFAULT  \
  {                                             \
    false   /* enabled */                      \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CRASH_HANDLER_H_
