#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CORE_DUMP_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CORE_DUMP_H_
/**
 * @file      vca/core_sdk/service/options/core_dump.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the core_dump server
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to the services core_dump server.
 * Note: This option is no longer in use. Setting it has no effect.
 */
struct VcaCoreServiceOptionsCoreDump {
  /**
   * @~english
   * The root location to serve core-dump files from. IF the value is set to @c NULL , then no core dump files will
   * be served.
   */
  const char* path;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsCoreDump</tt>. This can be used to initialize the structure if
 * needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsCoreDump core_dump_options = VCA_CORE_OPTIONS_CORE_DUMP_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_CORE_DUMP_DEFAULT  \
  {                                         \
    NULL   /* path */                       \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_CORE_DUMP_H_
