#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_ACTIONS_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_ACTIONS_H_
/**
 * @file      vca/core_sdk/service/options/user_channels.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options that are related to Actions
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options that are related to Actions.
 */
struct VcaCoreServiceOptionsActions {
  /**
   * @~english
   * Whether Actions are enabled or not.
   */
  bool enabled;
};

/**
 * @~english
 * The default options for the <tt>VcaCoreServiceOptionsActions</tt>. This can be used to initialize the structure
 * if needed.
 * @par Example
 * @code
 * struct VcaCoreServiceOptionsUserChannels user_channels_options = VCA_CORE_OPTIONS_ACTIONS_DEFAULT;
 * @endcode
 */
// clang-format off
#define VCA_CORE_OPTIONS_ACTIONS_DEFAULT  \
  {                                             \
    false   /* enabled */                      \
  }
// clang-format on

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_ACTIONS_H_
