#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_H_
/**
 * @file      vca/core_sdk/service/options.h
 * @copyright VCA Technology
 * @~english
 * @brief     Options for the VCA core library
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options/type.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * Options to modify the operation of the VCA core service library
 */
struct VcaCoreServiceOptions {
  /**
   * @~english
   * The type of this block of options.
   */
  enum VcaCoreServiceOptionsType type;

  /**
   * @~english
   * A pointer to the structure of options.
   */
  const void* options;
};

VCA_CORE_SDK_EXTERN_C_END

#endif  // INCLUDE_VCA_CORE_SDK_SERVICE_OPTIONS_H_
