#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_FROM_ARGS_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_FROM_ARGS_H_
/**
 * @file      vca/core_sdk/service/create_from_args.h
 * @copyright VCA Technology
 * @~english
 * @brief     Creates a VCA core service handle with command-line arguments.
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options.h>

#include <stddef.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Creates a new instance of a VCA core service using command line arguments.  Only one instance of the service may be
 * active at any given time.
 * @param argc the number of arguments.
 * @param argv a pointer to an array of pointers to strings containing the arguments.
 * @param default_options a pointer to a NULL-terminated array of options.
 * @returns a handle to the service
 */
VCA_CORE_SDK_DLL_PUBLIC
struct VcaCoreService* VcaCoreServiceCreateFromArgs(
  const int argc, const char* const* const argv, const struct VcaCoreServiceOptions* const* default_options
);

/**
 * @~english
 * Creates a new instance of a VCA core service using command line arguments. Only one instance of the service may be
 * active at any given time.
 * @param argc the number of arguments.
 * @param argv a pointer to an array of pointers to strings containing the arguments.
 * @param default_options a pointer to a NULL-terminated array of options.
 * @returns a handle to the service
 */
VCA_CORE_SDK_DLL_PUBLIC
struct VcaCoreService* VcaCoreServiceCreateFromArgsW(
  const int argc, const wchar_t* const* const argv, const struct VcaCoreServiceOptions* const* default_options
);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_FROM_ARGS_H_ */
