#ifndef INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_H_
#define INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_H_
/**
 * @file      vca/core_sdk/service/create.h
 * @copyright VCA Technology
 * @~english
 * @brief     Creates a VCA core service handle
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/service/options.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Creates a new instance of a VCA core service. Only one instance of the service may be active at any given time.
 * @param options a pointer to a NULL-terminated array of options.
 * @returns a handle to the service
 */
VCA_CORE_SDK_DLL_PUBLIC
struct VcaCoreService* VcaCoreServiceCreate(const struct VcaCoreServiceOptions* const* options);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_SERVICE_CREATE_H_ */
