#ifndef INCLUDE_VCA_CORE_SDK_CHANGE_PASSWORD_H_
#define INCLUDE_VCA_CORE_SDK_CHANGE_PASSWORD_H_
/**
 * @file      vca/core_sdk/service/authentication/change_password.h
 * @copyright VCA Technology
 * @~english
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Changes the password for the web service.
 * @param service A handle to the owning service
 * @param old_pass_hash The old password Md5 hashed with "admin:vcatechnology.com:old_pass".
 * @param new_pass_hash The new password Md5 hashed with "admin:vcatechnology.com:new_pass".
 * @returns A boolean which is true if the change was successful and false otherwise
 */
VCA_CORE_SDK_DLL_PUBLIC
bool VcaCoreAuthenticationChangePasswordHash(
  struct VcaCoreService* service, const char* old_pass_hash, const char* new_pass_hash
);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_CHANGE_PASSWORD_H_ */
