#ifndef INCLUDE_VCA_CORE_SDK_VIDEO_META_TO_JSON_H_
#define INCLUDE_VCA_CORE_SDK_VIDEO_META_TO_JSON_H_
/**
 * @file       vca/core_sdk/meta/to_json.h
 * @copyright  VCA Technology
 * @~english
 * @brief      Converts meta-data to JSON
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaMeta;

/**
 * @~english
 * Converts the given meta-data to a JSON string. The returned string is dynamically allocated and must be freed
 * using @c VcaCoreFree.
 * @param meta The meta-data object
 * @returns the JSON string
 */
VCA_CORE_SDK_DLL_PUBLIC
char* VcaCoreMetaToJson(const struct VcaMeta* meta);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_VIDEO_META_TO_JSON_H_ */
