#ifndef INCLUDE_VCA_CORE_SDK_MACROS_H_
#define INCLUDE_VCA_CORE_SDK_MACROS_H_
/**
 * @file      vca/core_sdk/macros.h
 * @copyright VCA Technology
 * @~english
 * @brief     Preprocessor helper macros.
 */

/**
 * @def VCA_CORE_SDK_EXTERN_C_BEGIN
 * @~english
 * Begins a C region when included in a C++ file.
 *
 * @def VCA_CORE_SDK_EXTERN_C_END
 * @~english
 * Ends a C region in C++ files.
 */
#ifdef __cplusplus
#define VCA_CORE_SDK_EXTERN_C_BEGIN extern "C" {
#define VCA_CORE_SDK_EXTERN_C_END }
#else
#define VCA_CORE_SDK_EXTERN_C_BEGIN
#define VCA_CORE_SDK_EXTERN_C_END
#endif

/**
 * @def VCA_CORE_SDK_DLL_PUBLIC
 * @~english
 * Enables public export of function in shared library
 *
 * @def VCA_CORE_SDK_DLL_LOCAL
 * @~english
 * Disables public export of function in shared library
 */
#if defined _WIN32 || defined __CYGWIN__
#ifdef VCA_PRODUCTS_CORE_SDK_BUILDING_DLL
#ifdef __GNUC__
#define VCA_CORE_SDK_DLL_PUBLIC __attribute__((dllexport))
#else
#define VCA_CORE_SDK_DLL_PUBLIC __declspec(dllexport)
#endif
#else
#ifdef __GNUC__
#define VCA_CORE_SDK_DLL_PUBLIC __attribute__((dllimport))
#else
#define VCA_CORE_SDK_DLL_PUBLIC __declspec(dllimport)
#endif
#endif
#define VCA_CORE_SDK_DLL_LOCAL
#elif __GNUC__ >= 4
#define VCA_CORE_SDK_DLL_PUBLIC __attribute__((visibility("default")))
#define VCA_CORE_SDK_DLL_LOCAL __attribute__((visibility("hidden")))
#else
#define VCA_CORE_SDK_DLL_PUBLIC
#define VCA_CORE_SDK_DLL_LOCAL
#endif

#endif /* INCLUDE_VCA_CORE_SDK_MACROS_H_ */
