#ifndef INCLUDE_VCA_CORE_SDK_GET_VERSION_H_
#define INCLUDE_VCA_CORE_SDK_GET_VERSION_H_
/**
 * @file      vca/core_sdk/get_version.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreGetVersion function.
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/version.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @ingroup core_sdk
 * @~english
 * Retrieves the version of this version of VCA core.
 * @returns a pointer to a @c VcaCoreVersion structure. The returned pointer does not need to be freed after use.
 */
VCA_CORE_SDK_DLL_PUBLIC
const struct VcaCoreVersion* VcaCoreGetVersion(void);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_GET_VERSION_H_ */
