#ifndef INCLUDE_VCA_CORE_SDK_CHANNEL_ID_H_
#define INCLUDE_VCA_CORE_SDK_CHANNEL_ID_H_
/**
 * @file      vca/core_sdk/channel/id.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelId type
 */

#include <vca/core_sdk/macros.h>
#include <vca/meta/data/id.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

/**
 * @~english
 * The id of a VCA core channel.
 */
typedef VcaMetaDataId VcaCoreChannelId;  // NOLINT(modernize-use-using)

/**
 * @~english
 * An ID value that indicates an invalid object
 */
#define VCA_CORE_CHANNEL_INVALID_ID VCA_META_DATA_INVALID_ID

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_CHANNEL_ID_H_ */
