#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_VIDEO_FORMATS_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_VIDEO_FORMATS_H_
/**
 * @file      vca/core_sdk/app_channel/set_video_formats.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelCreate function
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/status.h>
#include <vca/core_sdk/video/format.h>

#include <stddef.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Sets the buffer formats that will be pushed into a given channel.
 * @param channel the analytics channel to set the formats of
 * @param formats a pointer to an array of @c VcaCoreVideoFormat structures.
 * @param num_formats the number of structures present in the @c formats array.
 * @returns the status of the operation.
 * @remarks A channel may receive video frames in one or more video formats simultaneosly. In simple cases, only a
 *   single image format is required. In more complex applications, a given video source may be simultaneously
 *   represented by multiple image sizes, colour spaces, coding schemes, or even alternative frame-rates.
 */
VCA_CORE_SDK_DLL_PUBLIC
enum VcaCoreStatus VcaCoreAppChannelSetVideoFormats(
  struct VcaCoreAppChannel* channel, const struct VcaCoreVideoFormat* formats, size_t num_formats
);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_VIDEO_FORMATS_H_ */
