#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_NAME_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_NAME_H_
/**
 * @file      vca/core_sdk/app_channel/set_name.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelSetName function
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Sets the name of a channel.
 * @param channel The channel to set the name of.
 * @param name The name to set the channel to (can be @c NULL ).
 * @returns a handle to the channel
 */
VCA_CORE_SDK_DLL_PUBLIC
void VcaCoreAppChannelSetName(struct VcaCoreAppChannel* channel, const char* name);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_NAME_H_ */
