#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_ENABLED_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_ENABLED_H_
/**
 * @file      vca/core_sdk/app_channel/set_enabled.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelSetEnabled function
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Enables or disables the channel.
 * @param channel A handle to the app channel.
 * @param enabled @c true if the channel is to be enabled, or @c false if it is to be disabled.
 */
VCA_CORE_SDK_DLL_PUBLIC
void VcaCoreAppChannelSetEnabled(struct VcaCoreAppChannel* channel, bool enabled);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_SET_ENABLED_H_ */
