#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_REMOVE_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_REMOVE_H_
/**
 * @file      vca/core_sdk/app_channel/remove.h
 * @copyright VCA Technology
 * @~english
 * @brief     Remove an app channel from the VCA core configuration
 */

#include <vca/core_sdk/channel/id.h>
#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreService;

/**
 * @~english
 * Remove an app channel from the VCA core configuration. MT safe.
 * @param service a handle to the owning service
 * @param host_id Host ID of the channel to remove
 */
VCA_CORE_SDK_DLL_PUBLIC
void VcaCoreAppChannelRemove(struct VcaCoreService* const service, VcaCoreChannelId host_id);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_REMOVE_H_ */
