#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_PUSH_FRAME_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_PUSH_FRAME_H_
/**
 * @file      vca/core_sdk/app_channel/push_frame.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelPush function
 */

#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/status.h>
#include <vca/core_sdk/video/buffer.h>
#include <vca/media/timestamp.h>

#include <stddef.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Pushes a frame of data into the video pipeline.
 * @param channel the analytics channel in which to push data
 * @param buffers a pointer to an array of @c VcaMediaVideoBuffer structures containing pointers to the image data. The
 *   array should be ordered in the same way as the @c VcaCoreVideoFormat structures given in @c VcaCoreChannelPush. If
 *   a given buffer format is not present at this time-point, it can contain @c NULL pointers.
 * @param num_buffers the number of structures present in the @c buffers array.
 * @param timestamp the timestamp of this buffer in nanoseconds since the January 1, 1970 epoch.
 * @returns the status of the operation.
 */
VCA_CORE_SDK_DLL_PUBLIC
enum VcaCoreStatus VcaCoreAppChannelPushFrame(
  struct VcaCoreAppChannel* channel,
  const struct VcaCoreVideoBuffer* buffers,
  size_t num_buffers,
  VcaMediaTimestamp timestamp
);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_PUSH_FRAME_H_ */
