#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_NAME_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_NAME_H_
/**
 * @file      vca/core_sdk/app_channel/get_name.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelGetName function
 */

#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Gets the name of a channel.
 * @param app_channel A handle to the app channel.
 * @returns a pointer to null-terminated string of the channels name. This should be freed by @c VcaCoreFree after use.
 */
VCA_CORE_SDK_DLL_PUBLIC
const char* VcaCoreAppChannelGetName(struct VcaCoreAppChannel* app_channel);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_NAME_H_ */
