#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ID_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ID_H_
/**
 * @file      vca/core_sdk/app_channel/get_id.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelGetId function
 */

#include <vca/core_sdk/channel/id.h>
#include <vca/core_sdk/macros.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Gets the id of a channel.
 * @param app_channel A handle to the app channel.
 * @returns The id of the channel.
 */
VCA_CORE_SDK_DLL_PUBLIC
VcaCoreChannelId VcaCoreAppChannelGetId(struct VcaCoreAppChannel* app_channel);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ID_H_ */
