#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ENABLED_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ENABLED_H_
/**
 * @file      vca/core_sdk/app_channel/get_enabled.h
 * @copyright VCA Technology
 * @~english
 * @brief     Declares the @c VcaCoreAppChannelGetName function
 */

#include <vca/core_sdk/macros.h>

#include <stdbool.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;

/**
 * @~english
 * Checks if the channel is currently enabled.
 * @param app_channel A handle to the app channel.
 * @return @c true if the channel is enabled, @c false otherwise.
 */
VCA_CORE_SDK_DLL_PUBLIC
bool VcaCoreAppChannelGetEnabled(struct VcaCoreAppChannel* app_channel);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_GET_ENABLED_H_ */
