#ifndef INCLUDE_VCA_CORE_SDK_APP_CHANNEL_CREATE_H_
#define INCLUDE_VCA_CORE_SDK_APP_CHANNEL_CREATE_H_
/**
 * @file      vca/core_sdk/app_channel/create.h
 * @copyright VCA Technology
 * @~english
 * @brief     Creates a VCA core channel handle
 */

#include <vca/core_sdk/channel/id.h>
#include <vca/core_sdk/macros.h>
#include <vca/core_sdk/meta/function/push.h>

VCA_CORE_SDK_EXTERN_C_BEGIN

struct VcaCoreAppChannel;
struct VcaCoreService;

/**
 * @~english
 * Creates a new instance of a VCA core channel. MT safe.
 * @param service a handle to the owning service
 * @param host_id Unique, host-provided ID for this channel. If the host_id matches a channel that already exists in the
 *        VCA core configuration, that configuration will be used for this channel. Otherwise, a new channel will be
 *        added to the configuration.
 * @param name The name of the channel (can be @c NULL ).
 * @param meta_push An optional callback function that will be invoked when analytics results meta-data is received.
 *   Note that the calling thread which will invoke @c meta_push is undefined.
 * @param user_data A user data pointer that will be passed into the @c meta_push function when called.
 * @returns a handle to the channel
 */
VCA_CORE_SDK_DLL_PUBLIC
struct VcaCoreAppChannel* VcaCoreAppChannelCreate(
  struct VcaCoreService* service,
  VcaCoreChannelId host_id,
  const char* name,
  VcaCoreMetaFunctionPush meta_push,
  void* user_data
);

VCA_CORE_SDK_EXTERN_C_END

#endif /* INCLUDE_VCA_CORE_SDK_APP_CHANNEL_CREATE_H_ */
