/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 08/20/2010
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef _VN_PLAYER_STREAM_HANDLER_H_
#define _VN_PLAYER_STREAM_HANDLER_H_

#include "vn_player_internal.h"

class VN_Media_Stream_Handler : public videonext::media::MediaStreamHandler
{
private:
   typedef videonext::media::Frame Frame;
   typedef videonext::media::CacheBoundaries CacheBoundaries;
   typedef videonext::media::STREAM_STATE STREAM_STATE;
   typedef videonext::media::ResultStatus ResultStatus;
   typedef videonext::media::StreamInfo StreamInfo;
   typedef videonext::media::Report Report;
    

public:
   VN_Media_Stream_Handler(vn_player_context_t*);
  
   virtual ~VN_Media_Stream_Handler();

   virtual void newFrame(const Frame &frame, const CacheBoundaries &bounds);
   
   virtual void bufferChanged(const CacheBoundaries &bounds);
        
   virtual void stateChanged(STREAM_STATE state, const ResultStatus &status);
        
   virtual void newStream(const StreamInfo &streamInfo);

   virtual void removeStream(const StreamInfo &streamInfo);

   virtual void newReport(const Report &);

   virtual void* createImageBuffer(int width, int height, float dar);

   virtual void lockImageBuffer();
    
   virtual void unlockImageBuffer();

   virtual void recordingStatusChanged(const vn_player_recording_status_t &status);
    
   virtual void log(const char *msg);

   void set_enable_callbacks(bool val) { callbacks_enabled_ = val;}

private:
   struct vn_player_context_t *ctx_;
   struct vn_player_callbacks_t callbacks_;
   bool callbacks_enabled_;
   void *client_data_;
};

#endif /* _VN_PLAYER_STREAM_HANDLER_H_ */
