#ifndef _VN_CLIENT_INTERNAL_H_
#define _VN_CLIENT_INTERNAL_H_

#include "vn_malloc.h"
#include "vn_client.h"
#include "vn_client_curl.h"

const std::string PATH_GET_SETS("/api/call/getObjectList?type=set");
const std::string PATH_GET_RESOURCE_TREE("/api/call/getResourceTree");
const std::string PATH_GET_OBJECTS("/api/call/getObjectList?withAttributes=true");
const std::string PATH_GET_ROLES("/api/call/getObjectList?type=role");
const std::string PATH_GET_MOBILE_MEDIA_URL("/api/call/getMobileMediaURL");
const std::string PATH_ADD_OBJECT("/api/call/addObject");
const std::string PATH_LOGIN("/api/call/login");
const std::string PATH_LOGIN_INFO("/api/call/getLoginInfo");
const std::string PATH_SET_OBJECT_ATTRS("/api/call/setAttributes");
const std::string PATH_GET_EVENTS("/elog-restful/api/v2/alertlog/eventList");
const std::string PATH_AUTH_MGR("/api/call/authorizationManager");
const std::string PATH_LOGOUT("/api/call/logout");
const std::string PATH_GET_SNAPSHOT("/api/snapshot");
const std::string PATH_SEND_PTZ_COMMAND("/api/ptz");
const std::string PATH_GET_USERS("/api/call/getObjectList?type=user");
const std::string PATH_GET_SERVER_INFO("/api/call/getVersionControlInformation?section=info");
const std::string PATH_EVENT("/elog-restful/api/v2/alertlog/event");

struct vn_client_context
{
    vn_client_context();

    ~vn_client_context();

    CURLSH *curl_share;
    VN_Resource_Pool<CURL> *curl_pool;
    vn_client_config_t *cfg;
};

typedef ACE_Refcounted_Auto_Ptr<vn_client_context, ACE_Recursive_Thread_Mutex> VN_Client_Context_Ptr;

/////////////////
class VN_Client_Result_Handler : public VN_CURL_Result_Handler
{
public:
    VN_Client_Result_Handler(const VN_Client_Context_Ptr &c, const VN_Resource<CURL> &r, const VN_Asynch_Result_Ptr &a);
    virtual ~VN_Client_Result_Handler();

    vn_client_context *client_context();

protected:
    virtual void parse(vn_result_t *vn_result);

private:
    VN_Client_Context_Ptr client_context_ptr_;
    VN_Resource<CURL> resource_;
};
//////////////////

#endif /* _VN_CLIENT_INTERNAL_H_ */
