#ifndef _VN_ASYNCH_RESULT_INTERNAL_H_
#define _VN_ASYNCH_RESULT_INTERNAL_H_

#include "ace/Refcounted_Auto_Ptr.h"
#include "ace/Future.h"

#include "vn_asynch_result.h"


class VN_Asynch_Result : public ACE_Future<vn_asynch_result_t*>
{
public:
    VN_Asynch_Result(vn_asynch_result_t *ar);

    virtual ~VN_Asynch_Result();

    void clear();

    void set(vn_result_t *r);

private:
    vn_asynch_result_t *ar_;
    vn_result_t *r_;
};

class VN_Asynch_Result_Observer : public ACE_Future_Observer<vn_asynch_result_t*>
{
public:
    VN_Asynch_Result_Observer(vn_asynch_result_callback_t callback, void *user_data);

    virtual void update(const ACE_Future<vn_asynch_result_t*> &future);

private:
    vn_asynch_result_callback_t callback_;
    void *user_data_;
};

typedef ACE_Refcounted_Auto_Ptr<VN_Asynch_Result_Observer, ACE_Recursive_Thread_Mutex> VN_Asynch_Result_Observer_Ptr;
typedef ACE_Refcounted_Auto_Ptr<VN_Asynch_Result, ACE_Recursive_Thread_Mutex> VN_Asynch_Result_Ptr;

struct vn_asynch_result_t
{
    vn_asynch_result_t()
        : r(0)
    {}

    VN_Asynch_Result_Ptr future_ptr;
    VN_Asynch_Result_Observer_Ptr observer_ptr;
    vn_result_t *r;
};


#endif /* _VN_ASYNC_RESULT_INTERNAL_H_ */
