/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 09/18/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef __OS_DEP__
#define __OS_DEP__

#ifndef WIN32
#include <sys/types.h>      /* standard system types       */
#include <netinet/in.h>     /* Internet address structures */
#include <arpa/inet.h>
#include <sys/socket.h>     /* socket interface functions  */
#include <netdb.h>          /* host to IP resolution       */
#else
#ifndef _MSC_VER
#include <unistd.h>
#endif
#endif

#include <stdlib.h>
#include <stdio.h>          /* Basic I/O routines          */
#include <fcntl.h>          /* non-blocking connect */
#ifndef _MSC_VER
#include <unistd.h>
#endif
#include <time.h>
#include <errno.h>

int __get_errno();

#if not defined(__ANDROID__) || (__ANDROID_API__ >= __ANDROID_API_L__)
void __set_errno(int error);
#endif

#if defined(WIN32) || defined(__WIN32__) || defined(_WIN32) || defined(_WIN32_WCE) || defined(__MINGW32CE__)
#include <winerror.h>
#include <ws2tcpip.h>
#include <winsock2.h>
#include <windows.h>

/* This stuff does not exist in arm-mingw32ce. */
extern "C" {

#define socklen_t size_t

int strerror_r(int errnum, char *strerrbuf, size_t buflen);

char *getenv(const char *name);

void bzero(void *s, size_t n);

const char *inet_ntop(int af, const void *src, char *dst, socklen_t cnt);
}

#endif // WIN32

   
unsigned getCPUCount();

#endif // __OS_DEP__
