/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 12/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/
#ifndef VIDEOFRAMERATECONTROLLER_H
#define VIDEOFRAMERATECONTROLLER_H

#include "c_ptr.h"

#include <map>
#include "Mutex.h"
#include "Timeval.h"

namespace videonext { namespace media {

class VideoFrameConsumer;

typedef std::map<VideoFrameConsumer*, videonext::media::Timeval/*Next expected frame time*/> ConsumerTimers;

class VideoFrameRateController
{
public:
   
   static VideoFrameRateController* instance();

   void setMaxFrameRate(float);

   void addConsumer(VideoFrameConsumer*);

   void removeConsumer(VideoFrameConsumer*);

  /** 
   * Commit Consumer's frame. 
   * Every frame should be checked in  
   * 
   * @return false if commit was rejected by frame rate policy
   */
   bool commitFrame(VideoFrameConsumer*, CPMediaFrame&);

protected:
   VideoFrameRateController();
   ~VideoFrameRateController();


private:
   void resetTimers();

private:
   Mutex fConsumerMutex;
   float fMaxFrameRate; 
   float fCurrentFrameRate;
   float fFrameRatePerConsumer;
   time_t fLastFrameRateMeasureTime;
   ConsumerTimers fConsumerTimers;
};

}}

#endif /*VIDEOFRAMERATECONTROLLER_H*/

